﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.Xrm.Sdk;
using PpmsDataService.ModelsEnumTypes;
using PpmsDataService.Models;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;

namespace PpmsDataService.V1.Mappers
{
    public class ProviderSpecialtyMap
    {
        public static async Task<IQueryable<ProviderSpecialty>> MapProviderSpecialties(List<ppms_providertaxonomy> ppmsProviderSpecialties, string mapRelatedType, PpmsContext context)
        {
            var providerSpecialties = new List<ProviderSpecialty> { };
            foreach (var ppmsProviderSpecialty in ppmsProviderSpecialties)
            {
                
                var providerSpecialty = new ProviderSpecialty
                    {
                        Name = ppmsProviderSpecialty.ppms_name,

                    };

                if (ppmsProviderSpecialty.ppms_TaxonomyId != null)
                {
                    //Lookup the related Specialty
                    var specialty =
                        context.ppms_taxonomySet.First(i => i.Id == ppmsProviderSpecialty.ppms_TaxonomyId.Id);
                    providerSpecialty.Classification = specialty.ppms_classification;
                    providerSpecialty.Grouping = specialty.ppms_grouping;
                    providerSpecialty.Specialization = specialty.ppms_specialization;
                    providerSpecialty.SpecialtyDescription = specialty.ppms_specialtydescription;
                }


                if (ppmsProviderSpecialty.ppms_ProviderId != null)
                {
                    providerSpecialty.ProviderName = ppmsProviderSpecialty.ppms_ProviderId.Name;}

                //Is Primary Type Switch
                if (ppmsProviderSpecialty.ppms_PrimaryTaxonomy != null)
                    switch (ppmsProviderSpecialty.ppms_PrimaryTaxonomy.Value)
                    {
                        case true:
                            providerSpecialty.IsPrimaryType = IsPrimaryType.Yes;
                            break;
                        case false:
                            providerSpecialty.IsPrimaryType = IsPrimaryType.No;
                            break;
                    }

                if (ppmsProviderSpecialty.ppms_TaxonomyId != null)
                {
                    providerSpecialty.SpecialtyName = ppmsProviderSpecialty.ppms_TaxonomyId.Name;
                }

                providerSpecialty.CodedSpecialty = ppmsProviderSpecialty.ppms_codedspecialty;

                //Extract the Related type from queryType string
                if (mapRelatedType.Contains("?$expand=ProviderServices"))
                    mapRelatedType = "ProviderServices";
                if (mapRelatedType.Contains("?$expand=ProviderAgreements"))
                    mapRelatedType = "ProviderAgreements";
                if (mapRelatedType.Contains("?$expand=Provider"))
                    mapRelatedType = "Provider";
                if (mapRelatedType.Contains("?$expand=Specialty"))
                    mapRelatedType = "Specialty";

                //Map Related Type Switch
                switch (mapRelatedType)
                {
                    /*
                    case "ProviderServices":
                        //Lookup and Map the Provider Services
                        var ppmsProviderServices =
                            context.ppms_providerserviceSet.Where(i => i.ppms_ProviderSpecialty.Id == ppmsProviderSpecialty.Id);
                        var ppmsProviderServicesList = ppmsProviderServices.ToList();
                        providerSpecialty.ProviderServices =
                            await ProviderServicesMap.MapProviderServices(ppmsProviderServicesList, "None", context);
                        break;
                    */
                    case "ProviderAgreements":
                        //Lookup and Map the Provider Agreements
                        var ppmsProviderAgreements =
                            context.ppms_provideragreementSet.Where(i => i.ppms_CategoryofCare.Id == ppmsProviderSpecialty.Id);
                        var ppmsProviderAgreementsList = ppmsProviderAgreements.ToList();
                        providerSpecialty.ProviderAgreements =
                            await ProviderAgreementsMap.MapProviderAgreements(ppmsProviderAgreementsList, "None", context);
                        break;
                    case "Provider":
                        //Lookup and Map the Single Provider
                        var ppmsProvider =
                            context.AccountSet.FirstOrDefault(i => i.Id == ppmsProviderSpecialty.ppms_ProviderId.Id);
                        var ppmsProviderList = new List<Account> { ppmsProvider };
                        providerSpecialty.Provider =
                            await ProviderMap.MapProviders(ppmsProviderList, "None", context);
                        break;
                    case "Specialty":
                        //Lookup and Map the Single Specialty
                        var ppmsSpecialty =
                            context.ppms_taxonomySet.FirstOrDefault(i => i.Id == ppmsProviderSpecialty.ppms_TaxonomyId.Id);
                        var ppmsSpecialtyList = new List<ppms_taxonomy> { ppmsSpecialty };
                        providerSpecialty.Specialty =
                            await SpecialtyMap.MapSpecialties(ppmsSpecialtyList, "None", context);
                        break;

                    default:
                        break;
                }
                providerSpecialties.Add(providerSpecialty);               
            }
            return providerSpecialties.AsQueryable();
        }
    }
}